<?php

if(file_exists("../config.php")){
    die("⚠️ Project already installed. Delete config.php to reinstall.");
}

$step = $_GET['step'] ?? 1;

function h($string){
    return htmlspecialchars($string);
}

?>

<!DOCTYPE html>
<html>
<head>
    <title>ShieldCloud Bot Installer</title>
    <style>
        body{font-family:Tahoma;background:#111;color:#eee;padding:40px}
        input{padding:8px;margin:5px 0;width:300px}
        button{padding:10px 20px;background:#00bcd4;border:none;color:white}
        .box{background:#1e1e1e;padding:20px;border-radius:10px;width:400px}
    </style>
</head>
<body>

<div class="box">

<?php if($step == 1): ?>

<h2>Database Configuration</h2>

<form method="post" action="?step=2">
    DB Host:<br>
    <input name="db_host" required value="localhost"><br>

    DB Name:<br>
    <input name="db_name" required><br>

    DB User:<br>
    <input name="db_user" required><br>

    DB Password:<br>
    <input name="db_pass" type="password"><br>

    Bot Token:<br>
    <input name="bot_token" required><br>

    <button type="submit">Install</button>
</form>

<?php endif; ?>


<?php if($step == 2):

$db_host = $_POST['db_host'];
$db_name = $_POST['db_name'];
$db_user = $_POST['db_user'];
$db_pass = $_POST['db_pass'];
$bot_token = $_POST['bot_token'];

try{
    $pdo = new PDO("mysql:host=$db_host;charset=utf8mb4",$db_user,$db_pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $pdo->exec("CREATE DATABASE IF NOT EXISTS `$db_name` CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
    $pdo->exec("USE `$db_name`");

    // users table
    $pdo->exec("
    CREATE TABLE users (
        id INT AUTO_INCREMENT PRIMARY KEY,
        telegram_id BIGINT UNIQUE,
        username VARCHAR(100),
        first_name VARCHAR(100),
        linked TINYINT DEFAULT 0,
        virtualizor_userid INT NULL,
        report_enabled TINYINT DEFAULT 0,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    )");

    // traffic_reports table
    $pdo->exec("
    CREATE TABLE traffic_reports (
        id INT AUTO_INCREMENT PRIMARY KEY,
        user_id INT,
        server_name VARCHAR(150),
        server_ip VARCHAR(50),
        used_gb FLOAT DEFAULT 0,
        total_gb FLOAT DEFAULT 0,
        threshold_sent TINYINT DEFAULT 0,
        finished_sent TINYINT DEFAULT 0,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    )");

    // settings table
    $pdo->exec("
    CREATE TABLE settings (
        id INT AUTO_INCREMENT PRIMARY KEY,
        name VARCHAR(100) UNIQUE,
        value TEXT
    )");

    // default threshold setting
    $pdo->exec("
    INSERT INTO settings (name,value) VALUES
    ('traffic_threshold_gb','5')
    ");

    // create config.php
    $config = "<?php
define('DB_HOST','$db_host');
define('DB_NAME','$db_name');
define('DB_USER','$db_user');
define('DB_PASS','$db_pass');
define('BOT_TOKEN','$bot_token');
?>";

    file_put_contents("../config.php",$config);

    echo "<h2>✅ Installation Complete</h2>";
    echo "Delete install folder now.";
}
catch(Exception $e){
    echo "❌ Error: ".h($e->getMessage());
}

endif;
?>

</div>
</body>
</html>
