<?php
require_once 'virtualizor.php';
require_once 'db.php';

function getTrafficSmart($vpsid){

    $stmt=db()->prepare("SELECT * FROM cache_traffic WHERE vpsid=?");
    $stmt->execute([$vpsid]);
    $cache=$stmt->fetch(PDO::FETCH_ASSOC);

    if($cache && (time()-strtotime($cache['last_updated'])<60)){
        return $cache;
    }

    $traffic=fetchTrafficFromVirtualizor($vpsid);
    if(!$traffic) return false;

    db()->prepare("
    REPLACE INTO cache_traffic
    (vpsid,total_gb,used_gb,remain_gb,last_updated)
    VALUES (?,?,?,?,NOW())
    ")->execute([
        $vpsid,
        $traffic['total'],
        $traffic['used'],
        $traffic['remain']
    ]);

    return $traffic;
}
